/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASFormatter;
import com.ibm.ras.RASIEvent;
import java.io.PrintWriter;
import java.io.StringWriter;

public class RASTraceFormatter
extends RASFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static String[] attribs = new String[]{"className", "methodName", "threadID", "logger"};

    public RASTraceFormatter() {
        this.addEventClass("com.ibm.ras.RASTraceEvent");
    }

    public String format(RASIEvent rASIEvent) {
        String string = this.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(String.valueOf(this.getTime(rASIEvent.getTimeStamp())) + string);
        int n = 0;
        while (n < attribs.length) {
            String string2 = (String)rASIEvent.getAttribute(attribs[n]);
            if (string2 != null) {
                stringBuffer.append(String.valueOf(string2) + string);
            }
            ++n;
        }
        Exception exception = (Exception)rASIEvent.getAttribute("exception");
        if (exception != null) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(stringWriter.toString());
        } else {
            stringBuffer.append(rASIEvent.getText());
            String[] stringArray = rASIEvent.getParameters();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringBuffer.append(", p" + (n2 + 1) + "=" + stringArray[n2]);
                    ++n2;
                }
            }
        }
        return stringBuffer.toString();
    }
}

